/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker;

import LegendaryCardMaker.CustomCardMaker.CustomCardMaker;
import LegendaryCardMaker.CustomCardMaker.CustomCardMakerFrame;
import LegendaryCardMaker.CustomCardMaker.components.BackgroundImageMenuItem;
import LegendaryCardMaker.CustomCardMaker.components.CardNameMenuItem;
import LegendaryCardMaker.CustomCardMaker.components.CustomIconMenu;
import LegendaryCardMaker.CustomCardMaker.components.PropertyMenuItem;
import LegendaryCardMaker.CustomCardMaker.components.TextAreaMenuItem;
import LegendaryCardMaker.CustomCardMaker.components.TextMenuItem;
import LegendaryCardMaker.CustomCardMaker.structure.CustomElement;
import LegendaryCardMaker.CustomCardMaker.structure.CustomTemplate;
import LegendaryCardMaker.CustomCardMaker.structure.ElementBackgroundImage;
import LegendaryCardMaker.CustomCardMaker.structure.ElementCardName;
import LegendaryCardMaker.CustomCardMaker.structure.ElementIcon;
import LegendaryCardMaker.CustomCardMaker.structure.ElementProperty;
import LegendaryCardMaker.CustomCardMaker.structure.ElementText;
import LegendaryCardMaker.CustomCardMaker.structure.ElementTextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CustomCardMakerToolbar
extends JMenuBar
implements ActionListener {
    CustomCardMaker hm;
    CustomCardMakerFrame hmf;
    JMenu file = new JMenu("File");
    JMenuItem exportJPG = new JMenuItem("Export to JPEG...");
    JMenuItem exportPNG = new JMenuItem("Export to PNG...");
    JMenuItem exportPrinterStudioPNG = new JMenuItem("Export to Bordered PNG...");
    JMenuItem close = new JMenuItem("Close");
    JMenu edit = new JMenu("Edit");
    private Locale currentLocale = Locale.getDefault();
    private ResourceBundle labels = ResourceBundle.getBundle("LegendaryCardMaker.tools.language.LegendaryCardMakerMenu", this.currentLocale);
    static CustomCardMakerToolbar tb = null;

    public void setLanguage() {
        this.file.setText(this.labels.getString("File"));
        this.exportJPG.setText(this.labels.getString("ExporttoJPEG"));
        this.exportPNG.setText(this.labels.getString("ExporttoPNG"));
        this.exportPrinterStudioPNG.setText(this.labels.getString("ExporttoBorderedPNG"));
        this.close.setText(this.labels.getString("Close"));
        this.edit.setText(this.labels.getString("Edit"));
    }

    public CustomCardMakerToolbar(CustomCardMaker hm, CustomCardMakerFrame hmf) {
        this.setLanguage();
        tb = this;
        this.hm = hm;
        this.hmf = hmf;
        this.exportJPG.addActionListener(this);
        this.file.add(this.exportJPG);
        this.exportPNG.addActionListener(this);
        this.file.add(this.exportPNG);
        this.exportPrinterStudioPNG.addActionListener(this);
        this.file.add(this.exportPrinterStudioPNG);
        this.file.addSeparator();
        this.close.addActionListener(this);
        this.file.add(this.close);
        this.add(this.file);
        this.populateEditMenu(hm.template);
    }

    public void populateEditMenu(CustomTemplate t) {
        this.edit.removeAll();
        for (CustomElement e : t.elements) {
            if (e instanceof ElementIcon) {
                this.edit.add(new CustomIconMenu(this.hmf, (ElementIcon)e));
            }
            if (e instanceof ElementProperty) {
                this.edit.add(new PropertyMenuItem(this.hmf, (ElementProperty)e));
            }
            if (e instanceof ElementText && ((ElementText)e).linkedElement == null) {
                this.edit.add(new TextMenuItem(this.hmf, (ElementText)e));
            }
            if (e instanceof ElementCardName && ((ElementCardName)e).allowChange) {
                this.edit.add(new CardNameMenuItem(this.hmf, (ElementCardName)e));
            }
            if (e instanceof ElementTextArea && ((ElementTextArea)e).allowChange) {
                this.edit.add(new TextAreaMenuItem(this.hmf, (ElementTextArea)e));
            }
            if (!(e instanceof ElementBackgroundImage) || !((ElementBackgroundImage)e).allowChange) continue;
            this.edit.add(new BackgroundImageMenuItem(this.hmf, (ElementBackgroundImage)e));
        }
        this.add(this.edit);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int confirm;
        BufferedImage bi;
        int outcome;
        FileNameExtensionFilter filter1;
        JFileChooser chooser;
        if (e.getSource().equals(this.exportJPG)) {
            chooser = new JFileChooser();
            filter1 = new FileNameExtensionFilter("JPEG file", "jpg", "jpeg");
            chooser.addChoosableFileFilter(filter1);
            chooser.setFileFilter(filter1);
            outcome = chooser.showSaveDialog(this);
            if (outcome == 0) {
                bi = this.hm.generateCard();
                try {
                    if (!chooser.getSelectedFile().getName().toLowerCase().endsWith(".jpg") && !chooser.getSelectedFile().getName().toLowerCase().endsWith(".jpeg")) {
                        chooser.setSelectedFile(new File(String.valueOf(chooser.getSelectedFile().getAbsolutePath()) + ".jpg"));
                    }
                    if (chooser.getSelectedFile().exists()) {
                        confirm = JOptionPane.showConfirmDialog(this.hmf, "Overwrite File?", "File Exists", 0);
                        if (confirm == 0) {
                            this.hm.exportToJPEG(bi, chooser.getSelectedFile());
                        }
                    } else {
                        this.hm.exportToJPEG(bi, chooser.getSelectedFile());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, ex.getMessage());
                }
            }
        }
        if (e.getSource().equals(this.exportPNG)) {
            chooser = new JFileChooser();
            filter1 = new FileNameExtensionFilter("PNG file", "png");
            chooser.addChoosableFileFilter(filter1);
            chooser.setFileFilter(filter1);
            outcome = chooser.showSaveDialog(this);
            if (outcome == 0) {
                bi = this.hm.generateCard();
                try {
                    if (!chooser.getSelectedFile().getName().toLowerCase().endsWith(".png")) {
                        chooser.setSelectedFile(new File(String.valueOf(chooser.getSelectedFile().getAbsolutePath()) + ".png"));
                    }
                    if (chooser.getSelectedFile().exists()) {
                        confirm = JOptionPane.showConfirmDialog(this.hmf, "Overwrite File?", "File Exists", 0);
                        if (confirm == 0) {
                            this.hm.exportToPNG(bi, chooser.getSelectedFile());
                        }
                    } else {
                        this.hm.exportToPNG(bi, chooser.getSelectedFile());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, ex.getMessage());
                }
            }
        }
        if (e.getSource().equals(this.exportPrinterStudioPNG)) {
            chooser = new JFileChooser();
            filter1 = new FileNameExtensionFilter("PNG file", "png");
            chooser.addChoosableFileFilter(filter1);
            chooser.setFileFilter(filter1);
            outcome = chooser.showSaveDialog(this);
            if (outcome == 0) {
                bi = this.hm.generateCard();
                bi = this.hm.resizeImagePS(bi);
                try {
                    if (!chooser.getSelectedFile().getName().toLowerCase().endsWith(".png")) {
                        chooser.setSelectedFile(new File(String.valueOf(chooser.getSelectedFile().getAbsolutePath()) + ".png"));
                    }
                    if (chooser.getSelectedFile().exists()) {
                        int confirm2 = JOptionPane.showConfirmDialog(this.hmf, "Overwrite File?", "File Exists", 0);
                        if (confirm2 == 0) {
                            this.hm.exportToPNG(bi, chooser.getSelectedFile());
                        }
                    } else {
                        this.hm.exportToPNG(bi, chooser.getSelectedFile());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, ex.getMessage());
                }
            }
        }
    }

    public CustomCardMakerToolbar getHeroMakerToolbar() {
        return tb;
    }
}

